//
//  MainCountdownView.swift
//  death_app Watch App
//
//  Created by Task Master on 2025-09-16.
//

import SwiftUI

struct MainCountdownView: View {
    @StateObject private var viewModel = LifeExpectancyViewModel()
    @State private var currentDate = Date()
    
    private let timer = Timer.publish(every: 1, on: .main, in: .common).autoconnect()
    
    var body: some View {
        ScrollView {
            VStack(spacing: 12) {
                // Predicted Death Age Display
                VStack(spacing: 4) {
                    Text("Life Countdown")
                        .font(.caption2)
                        .foregroundColor(.secondary)
                    
                    Text("\(viewModel.predictedDeathAge)")
                        .font(.title2.weight(.bold))
                        .foregroundColor(.primary)
                        .accessibility(label: Text("Predicted death age: \(viewModel.predictedDeathAge)"))
                }
                .padding(.top, 8)
                
                // Countdown Display
                VStack(spacing: 8) {
                    HStack(spacing: 4) {
                        CountdownUnit(
                            value: viewModel.yearsRemaining,
                            unit: "Y",
                            accessibilityLabel: "Years"
                        )
                        
                        CountdownUnit(
                            value: viewModel.monthsRemaining,
                            unit: "M",
                            accessibilityLabel: "Months"
                        )
                        
                        CountdownUnit(
                            value: viewModel.daysRemaining,
                            unit: "D",
                            accessibilityLabel: "Days"
                        )
                    }
                    .font(.system(.body, design: .monospaced))
                    
                    // Daily Change Indicator
                    ChangeIndicatorView(
                        dailyChange: viewModel.dailyChangeInDays,
                        isPositive: viewModel.dailyChangeInDays > 0
                    )
                }
                
                // Mortality Indicator with Visual Feedback
                MortalityIndicator(
                    healthChangeState: viewModel.healthChangeState,
                    changeSeverity: viewModel.changeSeverity
                )
                .frame(height: 60)
                .padding(.vertical, 8)
                
                Spacer()
            }
            .padding(.horizontal, 8)
        }
        .navigationTitle("LifeClock")
        .navigationBarTitleDisplayMode(.inline)
        .onReceive(timer) { _ in
            currentDate = Date()
            viewModel.updateCountdown()
        }
        .onAppear {
            viewModel.startTracking()
        }
    }
}

#Preview {
    MainCountdownView()
}